'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var invariant = _interopDefault(require('tiny-invariant'));
var UniversalRouter = _interopDefault(require('@uniswap/universal-router/artifacts/contracts/UniversalRouter.sol/UniversalRouter.json'));
var abi = require('@ethersproject/abi');
var ethers = require('ethers');
var v3Sdk = require('@uniswap/v3-sdk');
var v4Sdk = require('@uniswap/v4-sdk');
var sdkCore = require('@uniswap/sdk-core');
var utils = require('ethers/lib/utils');
var v2Sdk = require('@uniswap/v2-sdk');
var routerSdk = require('@uniswap/router-sdk');
require('jsbi');
require('bignumber.js');

function _arrayLikeToArray(r, a) {
  (null == a || a > r.length) && (a = r.length);
  for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
  return n;
}
function _defineProperties(e, r) {
  for (var t = 0; t < r.length; t++) {
    var o = r[t];
    o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o);
  }
}
function _createClass(e, r, t) {
  return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", {
    writable: !1
  }), e;
}
function _createForOfIteratorHelperLoose(r, e) {
  var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
  if (t) return (t = t.call(r)).next.bind(t);
  if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) {
    t && (r = t);
    var o = 0;
    return function () {
      return o >= r.length ? {
        done: !0
      } : {
        done: !1,
        value: r[o++]
      };
    };
  }
  throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _toPrimitive(t, r) {
  if ("object" != typeof t || !t) return t;
  var e = t[Symbol.toPrimitive];
  if (void 0 !== e) {
    var i = e.call(t, r || "default");
    if ("object" != typeof i) return i;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return ("string" === r ? String : Number)(t);
}
function _toPropertyKey(t) {
  var i = _toPrimitive(t, "string");
  return "symbol" == typeof i ? i : i + "";
}
function _unsupportedIterableToArray(r, a) {
  if (r) {
    if ("string" == typeof r) return _arrayLikeToArray(r, a);
    var t = {}.toString.call(r).slice(8, -1);
    return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
  }
}

var _COMMAND_DEFINITION;
(function (CommandType) {
  CommandType[CommandType["V3_SWAP_EXACT_IN"] = 0] = "V3_SWAP_EXACT_IN";
  CommandType[CommandType["V3_SWAP_EXACT_OUT"] = 1] = "V3_SWAP_EXACT_OUT";
  CommandType[CommandType["PERMIT2_TRANSFER_FROM"] = 2] = "PERMIT2_TRANSFER_FROM";
  CommandType[CommandType["PERMIT2_PERMIT_BATCH"] = 3] = "PERMIT2_PERMIT_BATCH";
  CommandType[CommandType["SWEEP"] = 4] = "SWEEP";
  CommandType[CommandType["TRANSFER"] = 5] = "TRANSFER";
  CommandType[CommandType["PAY_PORTION"] = 6] = "PAY_PORTION";
  CommandType[CommandType["V2_SWAP_EXACT_IN"] = 8] = "V2_SWAP_EXACT_IN";
  CommandType[CommandType["V2_SWAP_EXACT_OUT"] = 9] = "V2_SWAP_EXACT_OUT";
  CommandType[CommandType["PERMIT2_PERMIT"] = 10] = "PERMIT2_PERMIT";
  CommandType[CommandType["WRAP_ETH"] = 11] = "WRAP_ETH";
  CommandType[CommandType["UNWRAP_WETH"] = 12] = "UNWRAP_WETH";
  CommandType[CommandType["PERMIT2_TRANSFER_FROM_BATCH"] = 13] = "PERMIT2_TRANSFER_FROM_BATCH";
  CommandType[CommandType["BALANCE_CHECK_ERC20"] = 14] = "BALANCE_CHECK_ERC20";
  CommandType[CommandType["V4_SWAP"] = 16] = "V4_SWAP";
  CommandType[CommandType["V3_POSITION_MANAGER_PERMIT"] = 17] = "V3_POSITION_MANAGER_PERMIT";
  CommandType[CommandType["V3_POSITION_MANAGER_CALL"] = 18] = "V3_POSITION_MANAGER_CALL";
  CommandType[CommandType["V4_INITIALIZE_POOL"] = 19] = "V4_INITIALIZE_POOL";
  CommandType[CommandType["V4_POSITION_MANAGER_CALL"] = 20] = "V4_POSITION_MANAGER_CALL";
  CommandType[CommandType["EXECUTE_SUB_PLAN"] = 33] = "EXECUTE_SUB_PLAN";
})(exports.CommandType || (exports.CommandType = {}));
(function (Subparser) {
  Subparser[Subparser["V3PathExactIn"] = 0] = "V3PathExactIn";
  Subparser[Subparser["V3PathExactOut"] = 1] = "V3PathExactOut";
})(exports.Subparser || (exports.Subparser = {}));
(function (Parser) {
  Parser[Parser["Abi"] = 0] = "Abi";
  Parser[Parser["V4Actions"] = 1] = "V4Actions";
  Parser[Parser["V3Actions"] = 2] = "V3Actions";
})(exports.Parser || (exports.Parser = {}));
var ALLOW_REVERT_FLAG = 0x80;
var REVERTIBLE_COMMANDS = /*#__PURE__*/new Set([exports.CommandType.EXECUTE_SUB_PLAN]);
var PERMIT_STRUCT = '((address token,uint160 amount,uint48 expiration,uint48 nonce) details,address spender,uint256 sigDeadline)';
var PERMIT_BATCH_STRUCT = '((address token,uint160 amount,uint48 expiration,uint48 nonce)[] details,address spender,uint256 sigDeadline)';
var POOL_KEY_STRUCT = '(address currency0,address currency1,uint24 fee,int24 tickSpacing,address hooks)';
var PERMIT2_TRANSFER_FROM_STRUCT = '(address from,address to,uint160 amount,address token)';
var PERMIT2_TRANSFER_FROM_BATCH_STRUCT = PERMIT2_TRANSFER_FROM_STRUCT + '[]';
var COMMAND_DEFINITION = (_COMMAND_DEFINITION = {}, _COMMAND_DEFINITION[exports.CommandType.EXECUTE_SUB_PLAN] = {
  parser: exports.Parser.Abi,
  params: [{
    name: 'commands',
    type: 'bytes'
  }, {
    name: 'inputs',
    type: 'bytes[]'
  }]
}, _COMMAND_DEFINITION[exports.CommandType.PERMIT2_PERMIT] = {
  parser: exports.Parser.Abi,
  params: [{
    name: 'permit',
    type: PERMIT_STRUCT
  }, {
    name: 'signature',
    type: 'bytes'
  }]
}, _COMMAND_DEFINITION[exports.CommandType.PERMIT2_PERMIT_BATCH] = {
  parser: exports.Parser.Abi,
  params: [{
    name: 'permit',
    type: PERMIT_BATCH_STRUCT
  }, {
    name: 'signature',
    type: 'bytes'
  }]
}, _COMMAND_DEFINITION[exports.CommandType.PERMIT2_TRANSFER_FROM] = {
  parser: exports.Parser.Abi,
  params: [{
    name: 'token',
    type: 'address'
  }, {
    name: 'recipient',
    type: 'address'
  }, {
    name: 'amount',
    type: 'uint160'
  }]
}, _COMMAND_DEFINITION[exports.CommandType.PERMIT2_TRANSFER_FROM_BATCH] = {
  parser: exports.Parser.Abi,
  params: [{
    name: 'transferFrom',
    type: PERMIT2_TRANSFER_FROM_BATCH_STRUCT
  }]
}, _COMMAND_DEFINITION[exports.CommandType.V3_SWAP_EXACT_IN] = {
  parser: exports.Parser.Abi,
  params: [{
    name: 'recipient',
    type: 'address'
  }, {
    name: 'amountIn',
    type: 'uint256'
  }, {
    name: 'amountOutMin',
    type: 'uint256'
  }, {
    name: 'path',
    subparser: exports.Subparser.V3PathExactIn,
    type: 'bytes'
  }, {
    name: 'payerIsUser',
    type: 'bool'
  }]
}, _COMMAND_DEFINITION[exports.CommandType.V3_SWAP_EXACT_OUT] = {
  parser: exports.Parser.Abi,
  params: [{
    name: 'recipient',
    type: 'address'
  }, {
    name: 'amountOut',
    type: 'uint256'
  }, {
    name: 'amountInMax',
    type: 'uint256'
  }, {
    name: 'path',
    subparser: exports.Subparser.V3PathExactOut,
    type: 'bytes'
  }, {
    name: 'payerIsUser',
    type: 'bool'
  }]
}, _COMMAND_DEFINITION[exports.CommandType.V2_SWAP_EXACT_IN] = {
  parser: exports.Parser.Abi,
  params: [{
    name: 'recipient',
    type: 'address'
  }, {
    name: 'amountIn',
    type: 'uint256'
  }, {
    name: 'amountOutMin',
    type: 'uint256'
  }, {
    name: 'path',
    type: 'address[]'
  }, {
    name: 'payerIsUser',
    type: 'bool'
  }]
}, _COMMAND_DEFINITION[exports.CommandType.V2_SWAP_EXACT_OUT] = {
  parser: exports.Parser.Abi,
  params: [{
    name: 'recipient',
    type: 'address'
  }, {
    name: 'amountOut',
    type: 'uint256'
  }, {
    name: 'amountInMax',
    type: 'uint256'
  }, {
    name: 'path',
    type: 'address[]'
  }, {
    name: 'payerIsUser',
    type: 'bool'
  }]
}, _COMMAND_DEFINITION[exports.CommandType.V4_SWAP] = {
  parser: exports.Parser.V4Actions
}, _COMMAND_DEFINITION[exports.CommandType.WRAP_ETH] = {
  parser: exports.Parser.Abi,
  params: [{
    name: 'recipient',
    type: 'address'
  }, {
    name: 'amount',
    type: 'uint256'
  }]
}, _COMMAND_DEFINITION[exports.CommandType.UNWRAP_WETH] = {
  parser: exports.Parser.Abi,
  params: [{
    name: 'recipient',
    type: 'address'
  }, {
    name: 'amountMin',
    type: 'uint256'
  }]
}, _COMMAND_DEFINITION[exports.CommandType.SWEEP] = {
  parser: exports.Parser.Abi,
  params: [{
    name: 'token',
    type: 'address'
  }, {
    name: 'recipient',
    type: 'address'
  }, {
    name: 'amountMin',
    type: 'uint256'
  }]
}, _COMMAND_DEFINITION[exports.CommandType.TRANSFER] = {
  parser: exports.Parser.Abi,
  params: [{
    name: 'token',
    type: 'address'
  }, {
    name: 'recipient',
    type: 'address'
  }, {
    name: 'value',
    type: 'uint256'
  }]
}, _COMMAND_DEFINITION[exports.CommandType.PAY_PORTION] = {
  parser: exports.Parser.Abi,
  params: [{
    name: 'token',
    type: 'address'
  }, {
    name: 'recipient',
    type: 'address'
  }, {
    name: 'bips',
    type: 'uint256'
  }]
}, _COMMAND_DEFINITION[exports.CommandType.BALANCE_CHECK_ERC20] = {
  parser: exports.Parser.Abi,
  params: [{
    name: 'owner',
    type: 'address'
  }, {
    name: 'token',
    type: 'address'
  }, {
    name: 'minBalance',
    type: 'uint256'
  }]
}, _COMMAND_DEFINITION[exports.CommandType.V4_INITIALIZE_POOL] = {
  parser: exports.Parser.Abi,
  params: [{
    name: 'poolKey',
    type: POOL_KEY_STRUCT
  }, {
    name: 'sqrtPriceX96',
    type: 'uint160'
  }]
}, _COMMAND_DEFINITION[exports.CommandType.V3_POSITION_MANAGER_PERMIT] = {
  parser: exports.Parser.V3Actions
}, _COMMAND_DEFINITION[exports.CommandType.V3_POSITION_MANAGER_CALL] = {
  parser: exports.Parser.V3Actions
}, _COMMAND_DEFINITION[exports.CommandType.V4_POSITION_MANAGER_CALL] = {
  parser: exports.Parser.V4Actions
}, _COMMAND_DEFINITION);
var RoutePlanner = /*#__PURE__*/function () {
  function RoutePlanner() {
    this.commands = '0x';
    this.inputs = [];
  }
  var _proto = RoutePlanner.prototype;
  _proto.addSubPlan = function addSubPlan(subplan) {
    this.addCommand(exports.CommandType.EXECUTE_SUB_PLAN, [subplan.commands, subplan.inputs], true);
    return this;
  };
  _proto.addCommand = function addCommand(type, parameters, allowRevert) {
    if (allowRevert === void 0) {
      allowRevert = false;
    }
    var command = createCommand(type, parameters);
    this.inputs.push(command.encodedInput);
    if (allowRevert) {
      if (!REVERTIBLE_COMMANDS.has(command.type)) {
        throw new Error("command type: " + command.type + " cannot be allowed to revert");
      }
      command.type = command.type | ALLOW_REVERT_FLAG;
    }
    this.commands = this.commands.concat(command.type.toString(16).padStart(2, '0'));
    return this;
  };
  return RoutePlanner;
}();
function createCommand(type, parameters) {
  var commandDef = COMMAND_DEFINITION[type];
  switch (commandDef.parser) {
    case exports.Parser.Abi:
      var encodedInput = utils.defaultAbiCoder.encode(commandDef.params.map(function (abi) {
        return abi.type;
      }), parameters);
      return {
        type: type,
        encodedInput: encodedInput
      };
    case exports.Parser.V4Actions:
      // v4 swap data comes pre-encoded at index 0
      return {
        type: type,
        encodedInput: parameters[0]
      };
    case exports.Parser.V3Actions:
      // v4 swap data comes pre-encoded at index 0
      return {
        type: type,
        encodedInput: parameters[0]
      };
  }
}

function getPathCurrency(currency, pool) {
  // return currency if the currency matches a currency of the pool
  if (pool.involvesToken(currency)) {
    return currency;
    // return if currency.wrapped if pool involves wrapped currency
  } else if (pool.involvesToken(currency.wrapped)) {
    return currency.wrapped;
    // return native currency if pool involves native version of wrapped currency (only applies to V4)
  } else if (pool instanceof v4Sdk.Pool && pool.token0.wrapped.equals(currency)) {
    return pool.token0;
  } else if (pool instanceof v4Sdk.Pool && pool.token1.wrapped.equals(currency)) {
    return pool.token1;
  } else {
    throw new Error("Expected currency " + currency.symbol + " to be either " + pool.token0.symbol + " or " + pool.token1.symbol);
  }
}

(function (RouterActionType) {
  RouterActionType["UniswapTrade"] = "UniswapTrade";
  RouterActionType["UnwrapWETH"] = "UnwrapWETH";
})(exports.RouterActionType || (exports.RouterActionType = {}));

var _routerConfigs, _routerConfigs2, _routerConfigs3, _routerConfigs4, _routerConfigs5, _routerConfigs6, _routerConfigs7, _routerConfigs8, _routerConfigs9, _routerConfigs10, _routerConfigs11, _routerConfigs12, _routerConfigs13, _routerConfigs14, _routerConfigs15, _routerConfigs16, _routerConfigs17, _routerConfigs18, _routerConfigs19, _routerConfigs20, _routerConfigs21, _routerConfigs22, _routerConfigs23, _routerConfigs24, _CHAIN_CONFIGS;
(function (UniversalRouterVersion) {
  UniversalRouterVersion["V1_2"] = "1.2";
  UniversalRouterVersion["V2_0"] = "2.0";
})(exports.UniversalRouterVersion || (exports.UniversalRouterVersion = {}));
var WETH_NOT_SUPPORTED_ON_CHAIN = '0x0000000000000000000000000000000000000000';
// Todo: Change `CHAIN_CONFIGS` to pull the UR address with v4
var CHAIN_CONFIGS = (_CHAIN_CONFIGS = {}, _CHAIN_CONFIGS[1] = {
  weth: '0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2',
  routerConfigs: (_routerConfigs = {}, _routerConfigs[exports.UniversalRouterVersion.V1_2] = {
    address: '0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD',
    creationBlock: 17143817
  }, _routerConfigs[exports.UniversalRouterVersion.V2_0] = {
    address: '0x66a9893cc07d91d95644aedd05d03f95e1dba8af',
    creationBlock: 1737658355
  }, _routerConfigs)
}, _CHAIN_CONFIGS[5] = {
  weth: '0xb4fbf271143f4fbf7b91a5ded31805e42b2208d6',
  routerConfigs: (_routerConfigs2 = {}, _routerConfigs2[exports.UniversalRouterVersion.V1_2] = {
    address: '0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD',
    creationBlock: 8940568
  }, _routerConfigs2[exports.UniversalRouterVersion.V2_0] = {
    address: '0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD',
    creationBlock: 8940568
  }, _routerConfigs2)
}, _CHAIN_CONFIGS[11155111] = {
  weth: '0xfFf9976782d46CC05630D1f6eBAb18b2324d6B14',
  routerConfigs: (_routerConfigs3 = {}, _routerConfigs3[exports.UniversalRouterVersion.V1_2] = {
    address: '0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD',
    creationBlock: 3543575
  }, _routerConfigs3[exports.UniversalRouterVersion.V2_0] = {
    address: '0x3a9d48ab9751398bbfa63ad67599bb04e4bdf98b',
    creationBlock: 7259601
  }, _routerConfigs3)
}, _CHAIN_CONFIGS[137] = {
  weth: '0x0d500B1d8E8eF31E21C99d1Db9A6444d3ADf1270',
  routerConfigs: (_routerConfigs4 = {}, _routerConfigs4[exports.UniversalRouterVersion.V1_2] = {
    address: '0xec7BE89e9d109e7e3Fec59c222CF297125FEFda2',
    creationBlock: 52210153
  }, _routerConfigs4[exports.UniversalRouterVersion.V2_0] = {
    address: '0x1095692a6237d83c6a72f3f5efedb9a670c49223',
    creationBlock: 1737492197
  }, _routerConfigs4)
}, _CHAIN_CONFIGS[80001] = {
  weth: '0x9c3C9283D3e44854697Cd22D3Faa240Cfb032889',
  routerConfigs: (_routerConfigs5 = {}, _routerConfigs5[exports.UniversalRouterVersion.V1_2] = {
    address: '0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD',
    creationBlock: 35176052
  }, _routerConfigs5[exports.UniversalRouterVersion.V2_0] = {
    address: '0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD',
    creationBlock: 35176052
  }, _routerConfigs5)
}, _CHAIN_CONFIGS[10] = {
  weth: '0x4200000000000000000000000000000000000006',
  routerConfigs: (_routerConfigs6 = {}, _routerConfigs6[exports.UniversalRouterVersion.V1_2] = {
    address: '0xCb1355ff08Ab38bBCE60111F1bb2B784bE25D7e8',
    creationBlock: 114702266
  }, _routerConfigs6[exports.UniversalRouterVersion.V2_0] = {
    address: '0x851116d9223fabed8e56c0e6b8ad0c31d98b3507',
    creationBlock: 1737494278
  }, _routerConfigs6)
}, _CHAIN_CONFIGS[420] = {
  weth: '0x4200000000000000000000000000000000000006',
  routerConfigs: (_routerConfigs7 = {}, _routerConfigs7[exports.UniversalRouterVersion.V1_2] = {
    address: '0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD',
    creationBlock: 8887728
  }, _routerConfigs7[exports.UniversalRouterVersion.V2_0] = {
    address: '0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD',
    creationBlock: 8887728
  }, _routerConfigs7)
}, _CHAIN_CONFIGS[42161] = {
  weth: '0x82aF49447D8a07e3bd95BD0d56f35241523fBab1',
  routerConfigs: (_routerConfigs8 = {}, _routerConfigs8[exports.UniversalRouterVersion.V1_2] = {
    address: '0x5E325eDA8064b456f4781070C0738d849c824258',
    creationBlock: 169472836
  }, _routerConfigs8[exports.UniversalRouterVersion.V2_0] = {
    address: '0xa51afafe0263b40edaef0df8781ea9aa03e381a3',
    creationBlock: 1737487458
  }, _routerConfigs8)
}, _CHAIN_CONFIGS[421613] = {
  weth: '0xe39Ab88f8A4777030A534146A9Ca3B52bd5D43A3',
  routerConfigs: (_routerConfigs9 = {}, _routerConfigs9[exports.UniversalRouterVersion.V1_2] = {
    address: '0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD',
    creationBlock: 18815277
  }, _routerConfigs9[exports.UniversalRouterVersion.V2_0] = {
    address: '0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD',
    creationBlock: 18815277
  }, _routerConfigs9)
}, _CHAIN_CONFIGS[42220] = {
  weth: WETH_NOT_SUPPORTED_ON_CHAIN,
  routerConfigs: (_routerConfigs10 = {}, _routerConfigs10[exports.UniversalRouterVersion.V1_2] = {
    address: '0x643770e279d5d0733f21d6dc03a8efbabf3255b4',
    creationBlock: 21407637
  }, _routerConfigs10[exports.UniversalRouterVersion.V2_0] = {
    address: '0x643770e279d5d0733f21d6dc03a8efbabf3255b4',
    creationBlock: 21407637
  }, _routerConfigs10)
}, _CHAIN_CONFIGS[44787] = {
  weth: WETH_NOT_SUPPORTED_ON_CHAIN,
  routerConfigs: (_routerConfigs11 = {}, _routerConfigs11[exports.UniversalRouterVersion.V1_2] = {
    address: '0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD',
    creationBlock: 17566658
  }, _routerConfigs11[exports.UniversalRouterVersion.V2_0] = {
    address: '0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD',
    creationBlock: 17566658
  }, _routerConfigs11)
}, _CHAIN_CONFIGS[56] = {
  weth: '0xbb4CdB9CBd36B01bD1cBaEBF2De08d9173bc095c',
  routerConfigs: (_routerConfigs12 = {}, _routerConfigs12[exports.UniversalRouterVersion.V1_2] = {
    address: '0x4Dae2f939ACf50408e13d58534Ff8c2776d45265',
    creationBlock: 35160263
  }, _routerConfigs12[exports.UniversalRouterVersion.V2_0] = {
    address: '0x1906c1d672b88cd1b9ac7593301ca990f94eae07',
    creationBlock: 1737493275
  }, _routerConfigs12)
}, _CHAIN_CONFIGS[43114] = {
  weth: '0xB31f66AA3C1e785363F0875A1B74E27b85FD66c7',
  routerConfigs: (_routerConfigs13 = {}, _routerConfigs13[exports.UniversalRouterVersion.V1_2] = {
    address: '0x4Dae2f939ACf50408e13d58534Ff8c2776d45265',
    creationBlock: 40237257
  }, _routerConfigs13[exports.UniversalRouterVersion.V2_0] = {
    address: '0x94b75331ae8d42c1b61065089b7d48fe14aa73b7',
    creationBlock: 1737558236
  }, _routerConfigs13)
}, _CHAIN_CONFIGS[84531] = {
  weth: '0x4200000000000000000000000000000000000006',
  routerConfigs: (_routerConfigs14 = {}, _routerConfigs14[exports.UniversalRouterVersion.V1_2] = {
    address: '0xd0872d928672ae2ff74bdb2f5130ac12229cafaf',
    creationBlock: 6915289
  }, _routerConfigs14[exports.UniversalRouterVersion.V2_0] = {
    address: '0xd0872d928672ae2ff74bdb2f5130ac12229cafaf',
    creationBlock: 6915289
  }, _routerConfigs14)
}, _CHAIN_CONFIGS[8453] = {
  weth: '0x4200000000000000000000000000000000000006',
  routerConfigs: (_routerConfigs15 = {}, _routerConfigs15[exports.UniversalRouterVersion.V1_2] = {
    address: '0x3fC91A3afd70395Cd496C647d5a6CC9D4B2b7FAD',
    creationBlock: 9107268
  }, _routerConfigs15[exports.UniversalRouterVersion.V2_0] = {
    address: '0x6ff5693b99212da76ad316178a184ab56d299b43',
    creationBlock: 1737491485
  }, _routerConfigs15)
}, _CHAIN_CONFIGS[81457] = {
  weth: '0x4300000000000000000000000000000000000004',
  routerConfigs: (_routerConfigs16 = {}, _routerConfigs16[exports.UniversalRouterVersion.V1_2] = {
    address: '0x643770E279d5D0733F21d6DC03A8efbABf3255B4',
    creationBlock: 1116444
  }, _routerConfigs16[exports.UniversalRouterVersion.V2_0] = {
    address: '0xeabbcb3e8e415306207ef514f660a3f820025be3',
    creationBlock: 1737564586
  }, _routerConfigs16)
}, _CHAIN_CONFIGS[7777777] = {
  weth: '0x4200000000000000000000000000000000000006',
  routerConfigs: (_routerConfigs17 = {}, _routerConfigs17[exports.UniversalRouterVersion.V1_2] = {
    address: '0x2986d9721A49838ab4297b695858aF7F17f38014',
    creationBlock: 11832155
  }, _routerConfigs17[exports.UniversalRouterVersion.V2_0] = {
    address: '0x3315ef7ca28db74abadc6c44570efdf06b04b020',
    creationBlock: 1737562927
  }, _routerConfigs17)
}, _CHAIN_CONFIGS[324] = {
  weth: '0x5aea5775959fbc2557cc8789bc1bf90a239d9a91',
  routerConfigs: (_routerConfigs18 = {}, _routerConfigs18[exports.UniversalRouterVersion.V1_2] = {
    address: '0x28731BCC616B5f51dD52CF2e4dF0E78dD1136C06',
    creationBlock: 12640979
  }, _routerConfigs18[exports.UniversalRouterVersion.V2_0] = {
    address: '0x28731BCC616B5f51dD52CF2e4dF0E78dD1136C06',
    creationBlock: 12640979
  }, _routerConfigs18)
}, _CHAIN_CONFIGS[480] = {
  weth: '0x4200000000000000000000000000000000000006',
  routerConfigs: (_routerConfigs19 = {}, _routerConfigs19[exports.UniversalRouterVersion.V1_2] = {
    address: '0x7a250d5630B4cF539739dF2C5dAcb4c659F2488D',
    creationBlock: 4063979
  }, _routerConfigs19[exports.UniversalRouterVersion.V2_0] = {
    address: '0x8ac7bee993bb44dab564ea4bc9ea67bf9eb5e743',
    creationBlock: 1737559557
  }, _routerConfigs19)
}, _CHAIN_CONFIGS[1301] = {
  weth: '0x4200000000000000000000000000000000000006',
  routerConfigs: (_routerConfigs20 = {}, _routerConfigs20[exports.UniversalRouterVersion.V1_2] = {
    address: '0x8909Dc15e40173Ff4699343b6eB8132c65e18eC6',
    creationBlock: 1241811
  }, _routerConfigs20[exports.UniversalRouterVersion.V2_0] = {
    address: '0xf70536b3bcc1bd1a972dc186a2cf84cc6da6be5d',
    creationBlock: 7100543
  }, _routerConfigs20)
}, _CHAIN_CONFIGS[130] = {
  weth: '0x4200000000000000000000000000000000000006',
  routerConfigs: (_routerConfigs21 = {}, _routerConfigs21[exports.UniversalRouterVersion.V1_2] = {
    address: '0x4D73A4411CA1c660035e4AECC8270E5DdDEC8C17',
    creationBlock: 23678
  }, _routerConfigs21[exports.UniversalRouterVersion.V2_0] = {
    address: '0xef740bf23acae26f6492b10de645d6b98dc8eaf3',
    creationBlock: 1737568156
  }, _routerConfigs21)
}, _CHAIN_CONFIGS[10143] = {
  weth: '0x760AfE86e5de5fa0Ee542fc7B7B713e1c5425701',
  routerConfigs: (_routerConfigs22 = {}, _routerConfigs22[exports.UniversalRouterVersion.V1_2] = {
    address: '0x3ae6d8a282d67893e17aa70ebffb33ee5aa65893',
    creationBlock: 23678
  }, _routerConfigs22[exports.UniversalRouterVersion.V2_0] = {
    address: '0x3ae6d8a282d67893e17aa70ebffb33ee5aa65893',
    creationBlock: 23678
  }, _routerConfigs22)
}, _CHAIN_CONFIGS[84532] = {
  weth: '0x4200000000000000000000000000000000000006',
  routerConfigs: (_routerConfigs23 = {}, _routerConfigs23[exports.UniversalRouterVersion.V1_2] = {
    address: '0x492e6456d9528771018deb9e87ef7750ef184104',
    creationBlock: 20216585
  }, _routerConfigs23[exports.UniversalRouterVersion.V2_0] = {
    address: '0x492e6456d9528771018deb9e87ef7750ef184104',
    creationBlock: 20216585
  }, _routerConfigs23)
}, _CHAIN_CONFIGS[1868] = {
  weth: '0x4200000000000000000000000000000000000006',
  routerConfigs: (_routerConfigs24 = {}, _routerConfigs24[exports.UniversalRouterVersion.V1_2] = {
    address: '0x0e2850543f69f678257266e0907ff9a58b3f13de',
    creationBlock: 3254782
  }, _routerConfigs24[exports.UniversalRouterVersion.V2_0] = {
    address: '0x0e2850543f69f678257266e0907ff9a58b3f13de',
    creationBlock: 3254782
  }, _routerConfigs24)
}, _CHAIN_CONFIGS);
var UNIVERSAL_ROUTER_ADDRESS = function UNIVERSAL_ROUTER_ADDRESS(version, chainId) {
  if (!(chainId in CHAIN_CONFIGS)) throw new Error("Universal Router not deployed on chain " + chainId);
  return CHAIN_CONFIGS[chainId].routerConfigs[version].address;
};
var UNIVERSAL_ROUTER_CREATION_BLOCK = function UNIVERSAL_ROUTER_CREATION_BLOCK(version, chainId) {
  if (!(chainId in CHAIN_CONFIGS)) throw new Error("Universal Router not deployed on chain " + chainId);
  return CHAIN_CONFIGS[chainId].routerConfigs[version].creationBlock;
};
var WETH_ADDRESS = function WETH_ADDRESS(chainId) {
  if (!(chainId in CHAIN_CONFIGS)) throw new Error("Universal Router not deployed on chain " + chainId);
  if (CHAIN_CONFIGS[chainId].weth == WETH_NOT_SUPPORTED_ON_CHAIN) throw new Error("Chain " + chainId + " does not have WETH");
  return CHAIN_CONFIGS[chainId].weth;
};
var CONTRACT_BALANCE = /*#__PURE__*/ethers.BigNumber.from(2).pow(255);
var ETH_ADDRESS = '0x0000000000000000000000000000000000000000';
var E_ETH_ADDRESS = '0xeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee';
var SENDER_AS_RECIPIENT = '0x0000000000000000000000000000000000000001';
var ROUTER_AS_RECIPIENT = '0x0000000000000000000000000000000000000002';

function getCurrencyAddress(currency) {
  return currency.isNative ? ETH_ADDRESS : currency.wrapped.address;
}

function encodeFeeBips(fee) {
  return v3Sdk.toHex(fee.multiply(10000).quotient);
}

var REFUND_ETH_PRICE_IMPACT_THRESHOLD = /*#__PURE__*/new sdkCore.Percent(50, 100);
// Wrapper for uniswap router-sdk trade entity to encode swaps for Universal Router
// also translates trade objects from previous (v2, v3) SDKs
var UniswapTrade = /*#__PURE__*/function () {
  function UniswapTrade(trade, options) {
    this.trade = trade;
    this.options = options;
    this.tradeType = exports.RouterActionType.UniswapTrade;
    if (!!options.fee && !!options.flatFee) throw new Error('Only one fee option permitted');
    if (this.inputRequiresWrap || this.inputRequiresUnwrap || this.options.useRouterBalance) {
      this.payerIsUser = false;
    } else {
      this.payerIsUser = true;
    }
  }
  var _proto = UniswapTrade.prototype;
  _proto.encode = function encode(planner, _config) {
    var _this$options$recipie;
    // If the input currency is the native currency, we need to wrap it with the router as the recipient
    if (this.inputRequiresWrap) {
      // TODO: optimize if only one v2 pool we can directly send this to the pool
      planner.addCommand(exports.CommandType.WRAP_ETH, [ROUTER_AS_RECIPIENT, this.trade.maximumAmountIn(this.options.slippageTolerance).quotient.toString()]);
    } else if (this.inputRequiresUnwrap) {
      // send wrapped token to router to unwrap
      planner.addCommand(exports.CommandType.PERMIT2_TRANSFER_FROM, [this.trade.inputAmount.currency.address, ROUTER_AS_RECIPIENT, this.trade.maximumAmountIn(this.options.slippageTolerance).quotient.toString()]);
      planner.addCommand(exports.CommandType.UNWRAP_WETH, [ROUTER_AS_RECIPIENT, 0]);
    }
    // The overall recipient at the end of the trade, SENDER_AS_RECIPIENT uses the msg.sender
    this.options.recipient = (_this$options$recipie = this.options.recipient) != null ? _this$options$recipie : SENDER_AS_RECIPIENT;
    // flag for whether we want to perform slippage check on aggregate output of multiple routes
    //   1. when there are >2 exact input trades. this is only a heuristic,
    //      as it's still more gas-expensive even in this case, but has benefits
    //      in that the reversion probability is lower
    var performAggregatedSlippageCheck = this.trade.tradeType === sdkCore.TradeType.EXACT_INPUT && this.trade.routes.length > 2;
    var routerMustCustody = performAggregatedSlippageCheck || this.outputRequiresTransition || hasFeeOption(this.options);
    for (var _iterator = _createForOfIteratorHelperLoose(this.trade.swaps), _step; !(_step = _iterator()).done;) {
      var swap = _step.value;
      switch (swap.route.protocol) {
        case routerSdk.Protocol.V2:
          addV2Swap(planner, swap, this.trade.tradeType, this.options, this.payerIsUser, routerMustCustody);
          break;
        case routerSdk.Protocol.V3:
          addV3Swap(planner, swap, this.trade.tradeType, this.options, this.payerIsUser, routerMustCustody);
          break;
        case routerSdk.Protocol.V4:
          addV4Swap(planner, swap, this.trade.tradeType, this.options, this.payerIsUser, routerMustCustody);
          break;
        case routerSdk.Protocol.MIXED:
          addMixedSwap(planner, swap, this.trade.tradeType, this.options, this.payerIsUser, routerMustCustody);
          break;
        default:
          throw new Error('UNSUPPORTED_TRADE_PROTOCOL');
      }
    }
    var minimumAmountOut = ethers.BigNumber.from(this.trade.minimumAmountOut(this.options.slippageTolerance).quotient.toString());
    // The router custodies for 3 reasons: to unwrap, to take a fee, and/or to do a slippage check
    if (routerMustCustody) {
      var pools = this.trade.swaps[0].route.pools;
      var pathOutputCurrencyAddress = getCurrencyAddress(getPathCurrency(this.trade.outputAmount.currency, pools[pools.length - 1]));
      // If there is a fee, that percentage is sent to the fee recipient
      // In the case where ETH is the output currency, the fee is taken in WETH (for gas reasons)
      if (!!this.options.fee) {
        var feeBips = encodeFeeBips(this.options.fee.fee);
        planner.addCommand(exports.CommandType.PAY_PORTION, [pathOutputCurrencyAddress, this.options.fee.recipient, feeBips]);
        // If the trade is exact output, and a fee was taken, we must adjust the amount out to be the amount after the fee
        // Otherwise we continue as expected with the trade's normal expected output
        if (this.trade.tradeType === sdkCore.TradeType.EXACT_OUTPUT) {
          minimumAmountOut = minimumAmountOut.sub(minimumAmountOut.mul(feeBips).div(10000));
        }
      }
      // If there is a flat fee, that absolute amount is sent to the fee recipient
      // In the case where ETH is the output currency, the fee is taken in WETH (for gas reasons)
      if (!!this.options.flatFee) {
        var feeAmount = this.options.flatFee.amount;
        if (minimumAmountOut.lt(feeAmount)) throw new Error('Flat fee amount greater than minimumAmountOut');
        planner.addCommand(exports.CommandType.TRANSFER, [pathOutputCurrencyAddress, this.options.flatFee.recipient, feeAmount]);
        // If the trade is exact output, and a fee was taken, we must adjust the amount out to be the amount after the fee
        // Otherwise we continue as expected with the trade's normal expected output
        if (this.trade.tradeType === sdkCore.TradeType.EXACT_OUTPUT) {
          minimumAmountOut = minimumAmountOut.sub(feeAmount);
        }
      }
      // The remaining tokens that need to be sent to the user after the fee is taken will be caught
      // by this if-else clause.
      if (this.outputRequiresUnwrap) {
        planner.addCommand(exports.CommandType.UNWRAP_WETH, [this.options.recipient, minimumAmountOut]);
      } else if (this.outputRequiresWrap) {
        planner.addCommand(exports.CommandType.WRAP_ETH, [this.options.recipient, CONTRACT_BALANCE]);
      } else {
        planner.addCommand(exports.CommandType.SWEEP, [getCurrencyAddress(this.trade.outputAmount.currency), this.options.recipient, minimumAmountOut]);
      }
    }
    // for exactOutput swaps with native input or that perform an inputToken transition (wrap or unwrap)
    // we need to send back the change to the user
    if (this.trade.tradeType === sdkCore.TradeType.EXACT_OUTPUT || riskOfPartialFill(this.trade)) {
      if (this.inputRequiresWrap) {
        planner.addCommand(exports.CommandType.UNWRAP_WETH, [this.options.recipient, 0]);
      } else if (this.inputRequiresUnwrap) {
        planner.addCommand(exports.CommandType.WRAP_ETH, [this.options.recipient, CONTRACT_BALANCE]);
      } else if (this.trade.inputAmount.currency.isNative) {
        // must refund extra native currency sent along for native v4 trades (no input transition)
        planner.addCommand(exports.CommandType.SWEEP, [ETH_ADDRESS, this.options.recipient, 0]);
      }
    }
    if (this.options.safeMode) planner.addCommand(exports.CommandType.SWEEP, [ETH_ADDRESS, this.options.recipient, 0]);
  };
  return _createClass(UniswapTrade, [{
    key: "isAllV4",
    get: function get() {
      var result = true;
      for (var _iterator2 = _createForOfIteratorHelperLoose(this.trade.swaps), _step2; !(_step2 = _iterator2()).done;) {
        var swap = _step2.value;
        result = result && swap.route.protocol == routerSdk.Protocol.V4;
      }
      return result;
    }
  }, {
    key: "inputRequiresWrap",
    get: function get() {
      if (this.isAllV4) {
        return this.trade.inputAmount.currency.isNative && !this.trade.swaps[0].route.pathInput.isNative;
      } else {
        return this.trade.inputAmount.currency.isNative;
      }
    }
  }, {
    key: "inputRequiresUnwrap",
    get: function get() {
      if (this.isAllV4) {
        return !this.trade.inputAmount.currency.isNative && this.trade.swaps[0].route.pathInput.isNative;
      }
      return false;
    }
  }, {
    key: "outputRequiresWrap",
    get: function get() {
      if (this.isAllV4) {
        return !this.trade.outputAmount.currency.isNative && this.trade.swaps[0].route.pathOutput.isNative;
      }
      return false;
    }
  }, {
    key: "outputRequiresUnwrap",
    get: function get() {
      if (this.isAllV4) {
        return this.trade.outputAmount.currency.isNative && !this.trade.swaps[0].route.pathOutput.isNative;
      } else {
        return this.trade.outputAmount.currency.isNative;
      }
    }
  }, {
    key: "outputRequiresTransition",
    get: function get() {
      return this.outputRequiresWrap || this.outputRequiresUnwrap;
    }
  }]);
}();
// encode a uniswap v2 swap
function addV2Swap(planner, _ref, tradeType, options, payerIsUser, routerMustCustody) {
  var route = _ref.route,
    inputAmount = _ref.inputAmount,
    outputAmount = _ref.outputAmount;
  var trade = new v2Sdk.Trade(route, tradeType == sdkCore.TradeType.EXACT_INPUT ? inputAmount : outputAmount, tradeType);
  if (tradeType == sdkCore.TradeType.EXACT_INPUT) {
    planner.addCommand(exports.CommandType.V2_SWAP_EXACT_IN, [
    // if native, we have to unwrap so keep in the router for now
    routerMustCustody ? ROUTER_AS_RECIPIENT : options.recipient, trade.maximumAmountIn(options.slippageTolerance).quotient.toString(),
    // if router will custody funds, we do aggregated slippage check from router
    routerMustCustody ? 0 : trade.minimumAmountOut(options.slippageTolerance).quotient.toString(), route.path.map(function (token) {
      return token.wrapped.address;
    }), payerIsUser]);
  } else if (tradeType == sdkCore.TradeType.EXACT_OUTPUT) {
    planner.addCommand(exports.CommandType.V2_SWAP_EXACT_OUT, [routerMustCustody ? ROUTER_AS_RECIPIENT : options.recipient, trade.minimumAmountOut(options.slippageTolerance).quotient.toString(), trade.maximumAmountIn(options.slippageTolerance).quotient.toString(), route.path.map(function (token) {
      return token.wrapped.address;
    }), payerIsUser]);
  }
}
// encode a uniswap v3 swap
function addV3Swap(planner, _ref2, tradeType, options, payerIsUser, routerMustCustody) {
  var route = _ref2.route,
    inputAmount = _ref2.inputAmount,
    outputAmount = _ref2.outputAmount;
  var trade = v3Sdk.Trade.createUncheckedTrade({
    route: route,
    inputAmount: inputAmount,
    outputAmount: outputAmount,
    tradeType: tradeType
  });
  var path = v3Sdk.encodeRouteToPath(route, trade.tradeType === sdkCore.TradeType.EXACT_OUTPUT);
  if (tradeType == sdkCore.TradeType.EXACT_INPUT) {
    planner.addCommand(exports.CommandType.V3_SWAP_EXACT_IN, [routerMustCustody ? ROUTER_AS_RECIPIENT : options.recipient, trade.maximumAmountIn(options.slippageTolerance).quotient.toString(), routerMustCustody ? 0 : trade.minimumAmountOut(options.slippageTolerance).quotient.toString(), path, payerIsUser]);
  } else if (tradeType == sdkCore.TradeType.EXACT_OUTPUT) {
    planner.addCommand(exports.CommandType.V3_SWAP_EXACT_OUT, [routerMustCustody ? ROUTER_AS_RECIPIENT : options.recipient, trade.minimumAmountOut(options.slippageTolerance).quotient.toString(), trade.maximumAmountIn(options.slippageTolerance).quotient.toString(), path, payerIsUser]);
  }
}
function addV4Swap(planner, _ref3, tradeType, options, payerIsUser, routerMustCustody) {
  var _options$recipient;
  var inputAmount = _ref3.inputAmount,
    outputAmount = _ref3.outputAmount,
    route = _ref3.route;
  // create a deep copy of pools since v4Planner encoding tampers with array
  var pools = route.pools.map(function (p) {
    return p;
  });
  var v4Route = new v4Sdk.Route(pools, inputAmount.currency, outputAmount.currency);
  var trade = v4Sdk.Trade.createUncheckedTrade({
    route: v4Route,
    inputAmount: inputAmount,
    outputAmount: outputAmount,
    tradeType: tradeType
  });
  var slippageToleranceOnSwap = routerMustCustody && tradeType == sdkCore.TradeType.EXACT_INPUT ? undefined : options.slippageTolerance;
  var v4Planner = new v4Sdk.V4Planner();
  v4Planner.addTrade(trade, slippageToleranceOnSwap);
  v4Planner.addSettle(trade.route.pathInput, payerIsUser);
  v4Planner.addTake(trade.route.pathOutput, routerMustCustody ? ROUTER_AS_RECIPIENT : (_options$recipient = options.recipient) != null ? _options$recipient : SENDER_AS_RECIPIENT);
  planner.addCommand(exports.CommandType.V4_SWAP, [v4Planner.finalize()]);
}
// encode a mixed route swap, i.e. including both v2 and v3 pools
function addMixedSwap(planner, swap, tradeType, options, payerIsUser, routerMustCustody) {
  var _options$recipient2;
  var route = swap.route;
  var inputAmount = swap.inputAmount;
  var outputAmount = swap.outputAmount;
  var tradeRecipient = routerMustCustody ? ROUTER_AS_RECIPIENT : (_options$recipient2 = options.recipient) != null ? _options$recipient2 : SENDER_AS_RECIPIENT;
  // single hop, so it can be reduced to plain swap logic for one protocol version
  if (route.pools.length === 1) {
    if (route.pools[0] instanceof v4Sdk.Pool) {
      return addV4Swap(planner, swap, tradeType, options, payerIsUser, routerMustCustody);
    } else if (route.pools[0] instanceof v3Sdk.Pool) {
      return addV3Swap(planner, swap, tradeType, options, payerIsUser, routerMustCustody);
    } else if (route.pools[0] instanceof v2Sdk.Pair) {
      return addV2Swap(planner, swap, tradeType, options, payerIsUser, routerMustCustody);
    } else {
      throw new Error('Invalid route type');
    }
  }
  var trade = routerSdk.MixedRouteTrade.createUncheckedTrade({
    route: route,
    inputAmount: inputAmount,
    outputAmount: outputAmount,
    tradeType: tradeType
  });
  var amountIn = trade.maximumAmountIn(options.slippageTolerance, inputAmount).quotient.toString();
  var amountOut = routerMustCustody ? 0 : trade.minimumAmountOut(options.slippageTolerance, outputAmount).quotient.toString();
  // logic from
  // https://github.com/Uniswap/router-sdk/blob/d8eed164e6c79519983844ca8b6a3fc24ebcb8f8/src/swapRouter.ts#L276
  var sections = routerSdk.partitionMixedRouteByProtocol(route);
  var isLastSectionInRoute = function isLastSectionInRoute(i) {
    return i === sections.length - 1;
  };
  var inputToken = route.pathInput;
  for (var i = 0; i < sections.length; i++) {
    var section = sections[i];
    var routePool = section[0];
    var outputToken = routerSdk.getOutputOfPools(section, inputToken);
    var subRoute = new routerSdk.MixedRoute(new routerSdk.MixedRouteSDK([].concat(section), inputToken, outputToken));
    var nextInputToken = void 0;
    var swapRecipient = void 0;
    if (isLastSectionInRoute(i)) {
      nextInputToken = outputToken;
      swapRecipient = tradeRecipient;
    } else {
      var nextPool = sections[i + 1][0];
      nextInputToken = getPathCurrency(outputToken, nextPool);
      var v2PoolIsSwapRecipient = nextPool instanceof v2Sdk.Pair && outputToken.equals(nextInputToken);
      swapRecipient = v2PoolIsSwapRecipient ? nextPool.liquidityToken.address : ROUTER_AS_RECIPIENT;
    }
    if (routePool instanceof v4Sdk.Pool) {
      var v4Planner = new v4Sdk.V4Planner();
      var v4SubRoute = new v4Sdk.Route(section, subRoute.input, subRoute.output);
      v4Planner.addSettle(inputToken, payerIsUser && i === 0, i == 0 ? amountIn : CONTRACT_BALANCE);
      v4Planner.addAction(v4Sdk.Actions.SWAP_EXACT_IN, [{
        currencyIn: inputToken.isNative ? ETH_ADDRESS : inputToken.address,
        path: v4Sdk.encodeRouteToPath(v4SubRoute),
        amountIn: 0,
        amountOutMinimum: !isLastSectionInRoute(i) ? 0 : amountOut
      }]);
      v4Planner.addTake(outputToken, swapRecipient);
      planner.addCommand(exports.CommandType.V4_SWAP, [v4Planner.finalize()]);
    } else if (routePool instanceof v3Sdk.Pool) {
      planner.addCommand(exports.CommandType.V3_SWAP_EXACT_IN, [swapRecipient, i == 0 ? amountIn : CONTRACT_BALANCE, !isLastSectionInRoute(i) ? 0 : amountOut, routerSdk.encodeMixedRouteToPath(subRoute), payerIsUser && i === 0]);
    } else if (routePool instanceof v2Sdk.Pair) {
      planner.addCommand(exports.CommandType.V2_SWAP_EXACT_IN, [swapRecipient, i === 0 ? amountIn : CONTRACT_BALANCE, !isLastSectionInRoute(i) ? 0 : amountOut, subRoute.path.map(function (token) {
        return token.wrapped.address;
      }), payerIsUser && i === 0]);
    } else {
      throw new Error('Unexpected Pool Type');
    }
    // perform a token transition (wrap/unwrap if necessary)
    if (!isLastSectionInRoute(i)) {
      if (outputToken.isNative && !nextInputToken.isNative) {
        planner.addCommand(exports.CommandType.WRAP_ETH, [ROUTER_AS_RECIPIENT, CONTRACT_BALANCE]);
      } else if (!outputToken.isNative && nextInputToken.isNative) {
        planner.addCommand(exports.CommandType.UNWRAP_WETH, [ROUTER_AS_RECIPIENT, 0]);
      }
    }
    inputToken = nextInputToken;
  }
}
// if price impact is very high, there's a chance of hitting max/min prices resulting in a partial fill of the swap
function riskOfPartialFill(trade) {
  return trade.priceImpact.greaterThan(REFUND_ETH_PRICE_IMPACT_THRESHOLD);
}
function hasFeeOption(swapOptions) {
  return !!swapOptions.fee || !!swapOptions.flatFee;
}

var SIGNATURE_LENGTH = 65;
var EIP_2098_SIGNATURE_LENGTH = 64;
function encodePermit(planner, permit2) {
  var signature = permit2.signature;
  var length = ethers.ethers.utils.arrayify(permit2.signature).length;
  // signature data provided for EIP-1271 may have length different from ECDSA signature
  if (length === SIGNATURE_LENGTH || length === EIP_2098_SIGNATURE_LENGTH) {
    // sanitizes signature to cover edge cases of malformed EIP-2098 sigs and v used as recovery id
    signature = ethers.ethers.utils.joinSignature(ethers.ethers.utils.splitSignature(permit2.signature));
  }
  planner.addCommand(exports.CommandType.PERMIT2_PERMIT, [permit2, signature]);
}
function encodeV3PositionPermit(planner, permit, tokenId) {
  var calldata = v3Sdk.NonfungiblePositionManager.INTERFACE.encodeFunctionData('permit', [sdkCore.validateAndParseAddress(permit.spender), tokenId, permit.deadline, permit.v, permit.r, permit.s]);
  planner.addCommand(exports.CommandType.V3_POSITION_MANAGER_PERMIT, [calldata]);
}
// Handles the encoding of commands needed to gather input tokens for a trade
// Approval: The router approving another address to take tokens.
//   note: Only seaport and sudoswap support this action. Approvals are left open.
// Permit: A Permit2 signature-based Permit to allow the router to access a user's tokens
// Transfer: A Permit2 TransferFrom of tokens from a user to either the router or another address
function encodeInputTokenOptions(planner, options) {
  // first ensure that all tokens provided for encoding are the same
  if (!!options.permit2TransferFrom && !!options.permit2Permit) !(options.permit2TransferFrom.token === options.permit2Permit.details.token) ?  invariant(false, "inconsistent token")  : void 0;
  // if this order has a options.permit2Permit, encode it
  if (!!options.permit2Permit) {
    encodePermit(planner, options.permit2Permit);
  }
  if (!!options.permit2TransferFrom) {
    planner.addCommand(exports.CommandType.PERMIT2_TRANSFER_FROM, [options.permit2TransferFrom.token, options.permit2TransferFrom.recipient ? options.permit2TransferFrom.recipient : ROUTER_AS_RECIPIENT, options.permit2TransferFrom.amount]);
  }
}

function isMint(options) {
  return Object.keys(options).some(function (k) {
    return k === 'recipient';
  });
}
var SwapRouter = /*#__PURE__*/function () {
  function SwapRouter() {}
  SwapRouter.swapCallParameters = function swapCallParameters(trades, options) {
    // TODO: use permit if signature included in swapOptions
    var planner = new RoutePlanner();
    var trade = new UniswapTrade(trades, options);
    var inputCurrency = trade.trade.inputAmount.currency;
    !!(inputCurrency.isNative && !!options.inputTokenPermit) ?  invariant(false, 'NATIVE_INPUT_PERMIT')  : void 0;
    if (options.inputTokenPermit) {
      encodePermit(planner, options.inputTokenPermit);
    }
    var nativeCurrencyValue = inputCurrency.isNative ? ethers.BigNumber.from(trade.trade.maximumAmountIn(options.slippageTolerance).quotient.toString()) : ethers.BigNumber.from(0);
    trade.encode(planner, {
      allowRevert: false
    });
    return SwapRouter.encodePlan(planner, nativeCurrencyValue, {
      deadline: options.deadlineOrPreviousBlockhash ? ethers.BigNumber.from(options.deadlineOrPreviousBlockhash) : undefined
    });
  }
  /**
   * Builds the call parameters for a migration from a V3 position to a V4 position.
   * Some requirements of the parameters:
   *   - v3RemoveLiquidityOptions.collectOptions.recipient must equal v4PositionManager
   *   - v3RemoveLiquidityOptions.liquidityPercentage must be 100%
   *   - input pool and output pool must have the same tokens
   *   - V3 NFT must be approved, or valid inputV3NFTPermit must be provided with UR as spender
   */;
  SwapRouter.migrateV3ToV4CallParameters = function migrateV3ToV4CallParameters(options, positionManagerOverride) {
    var v4Pool = options.outputPosition.pool;
    var v3Token0 = options.inputPosition.pool.token0;
    var v3Token1 = options.inputPosition.pool.token1;
    var v4PositionManagerAddress = positionManagerOverride != null ? positionManagerOverride : sdkCore.CHAIN_TO_ADDRESSES_MAP[v4Pool.chainId].v4PositionManagerAddress;
    // owner of the v3 nft must be the receiver of the v4 nft
    // validate the parameters
    if (v4Pool.currency0.isNative) {
      !(v4Pool.currency0.wrapped.equals(v3Token0) && v4Pool.currency1.equals(v3Token1) || v4Pool.currency0.wrapped.equals(v3Token1) && v4Pool.currency1.equals(v3Token0)) ?  invariant(false, 'TOKEN_MISMATCH')  : void 0;
    } else {
      !(v3Token0 === v4Pool.token0) ?  invariant(false, 'TOKEN0_MISMATCH')  : void 0;
      !(v3Token1 === v4Pool.token1) ?  invariant(false, 'TOKEN1_MISMATCH')  : void 0;
    }
    !options.v3RemoveLiquidityOptions.liquidityPercentage.equalTo(new sdkCore.Percent(100, 100)) ?  invariant(false, 'FULL_REMOVAL_REQUIRED')  : void 0;
    !(options.v3RemoveLiquidityOptions.burnToken == true) ?  invariant(false, 'BURN_TOKEN_REQUIRED')  : void 0;
    !(options.v3RemoveLiquidityOptions.collectOptions.recipient === v4PositionManagerAddress) ?  invariant(false, 'RECIPIENT_NOT_POSITION_MANAGER')  : void 0;
    !isMint(options.v4AddLiquidityOptions) ?  invariant(false, 'MINT_REQUIRED')  : void 0;
    !options.v4AddLiquidityOptions.migrate ?  invariant(false, 'MIGRATE_REQUIRED')  : void 0;
    var planner = new RoutePlanner();
    // to prevent reentrancy by the pool hook, we initialize the v4 pool before moving funds
    if (options.v4AddLiquidityOptions.createPool) {
      var poolKey = v4Sdk.Pool.getPoolKey(v4Pool.currency0, v4Pool.currency1, v4Pool.fee, v4Pool.tickSpacing, v4Pool.hooks);
      planner.addCommand(exports.CommandType.V4_INITIALIZE_POOL, [poolKey, v4Pool.sqrtRatioX96.toString()]);
      // remove createPool setting, so that it doesnt get encoded again later
      delete options.v4AddLiquidityOptions.createPool;
    }
    // add position permit to the universal router planner
    if (options.v3RemoveLiquidityOptions.permit) {
      // permit spender should be UR
      var universalRouterAddress = UNIVERSAL_ROUTER_ADDRESS(exports.UniversalRouterVersion.V2_0, options.inputPosition.pool.chainId);
      !(universalRouterAddress == options.v3RemoveLiquidityOptions.permit.spender) ?  invariant(false, 'INVALID_SPENDER')  : void 0;
      // don't need to transfer it because v3posm uses isApprovedOrOwner()
      encodeV3PositionPermit(planner, options.v3RemoveLiquidityOptions.permit, options.v3RemoveLiquidityOptions.tokenId);
      // remove permit so that multicall doesnt add it again
      delete options.v3RemoveLiquidityOptions.permit;
    }
    // encode v3 withdraw
    var v3RemoveParams = v3Sdk.NonfungiblePositionManager.removeCallParameters(options.inputPosition, options.v3RemoveLiquidityOptions);
    var v3Calls = v3Sdk.Multicall.decodeMulticall(v3RemoveParams.calldata);
    for (var _iterator = _createForOfIteratorHelperLoose(v3Calls), _step; !(_step = _iterator()).done;) {
      var v3Call = _step.value;
      // slice selector - 0x + 4 bytes = 10 characters
      var _selector = v3Call.slice(0, 10);
      !(_selector == v3Sdk.NonfungiblePositionManager.INTERFACE.getSighash('collect') || _selector == v3Sdk.NonfungiblePositionManager.INTERFACE.getSighash('decreaseLiquidity') || _selector == v3Sdk.NonfungiblePositionManager.INTERFACE.getSighash('burn')) ?  invariant(false, 'INVALID_V3_CALL: ' + _selector)  : void 0;
      planner.addCommand(exports.CommandType.V3_POSITION_MANAGER_CALL, [v3Call]);
    }
    // encode v4 mint
    var v4AddParams = v4Sdk.V4PositionManager.addCallParameters(options.outputPosition, options.v4AddLiquidityOptions);
    // only modifyLiquidities can be called by the UniversalRouter
    var selector = v4AddParams.calldata.slice(0, 10);
    !(selector == v4Sdk.V4PositionManager.INTERFACE.getSighash('modifyLiquidities')) ?  invariant(false, 'INVALID_V4_CALL: ' + selector)  : void 0;
    planner.addCommand(exports.CommandType.V4_POSITION_MANAGER_CALL, [v4AddParams.calldata]);
    return SwapRouter.encodePlan(planner, ethers.BigNumber.from(0), {
      deadline: ethers.BigNumber.from(options.v4AddLiquidityOptions.deadline)
    });
  }
  /**
   * Encodes a planned route into a method name and parameters for the Router contract.
   * @param planner the planned route
   * @param nativeCurrencyValue the native currency value of the planned route
   * @param config the router config
   */;
  SwapRouter.encodePlan = function encodePlan(planner, nativeCurrencyValue, config) {
    if (config === void 0) {
      config = {};
    }
    var commands = planner.commands,
      inputs = planner.inputs;
    var functionSignature = !!config.deadline ? 'execute(bytes,bytes[],uint256)' : 'execute(bytes,bytes[])';
    var parameters = !!config.deadline ? [commands, inputs, config.deadline] : [commands, inputs];
    var calldata = SwapRouter.INTERFACE.encodeFunctionData(functionSignature, parameters);
    return {
      calldata: calldata,
      value: nativeCurrencyValue.toHexString()
    };
  };
  return SwapRouter;
}();
SwapRouter.INTERFACE = /*#__PURE__*/new abi.Interface(UniversalRouter.abi);

var UnwrapWETH = /*#__PURE__*/function () {
  function UnwrapWETH(amount, chainId, permit2) {
    this.tradeType = exports.RouterActionType.UnwrapWETH;
    this.wethAddress = WETH_ADDRESS(chainId);
    this.amount = amount;
    if (!!permit2) {
      !(permit2.details.token.toLowerCase() === this.wethAddress.toLowerCase()) ?  invariant(false, "must be permitting WETH address: " + this.wethAddress)  : void 0;
      !(permit2.details.amount >= amount) ?  invariant(false, "Did not permit enough WETH for unwrapWETH transaction")  : void 0;
      this.permit2Data = permit2;
    }
  }
  var _proto = UnwrapWETH.prototype;
  _proto.encode = function encode(planner, _) {
    encodeInputTokenOptions(planner, {
      permit2Permit: this.permit2Data,
      permit2TransferFrom: {
        token: this.wethAddress,
        amount: this.amount.toString()
      }
    });
    planner.addCommand(exports.CommandType.UNWRAP_WETH, [ROUTER_AS_RECIPIENT, this.amount]);
  };
  return UnwrapWETH;
}();

(function (PoolType) {
  PoolType["V2Pool"] = "v2-pool";
  PoolType["V3Pool"] = "v3-pool";
  PoolType["V4Pool"] = "v4-pool";
})(exports.PoolType || (exports.PoolType = {}));
var isNativeCurrency = function isNativeCurrency(address) {
  return address.toLowerCase() === ETH_ADDRESS.toLowerCase() || address.toLowerCase() === E_ETH_ADDRESS.toLowerCase();
};
// Helper class to convert routing-specific quote entities to RouterTrade entities
// the returned RouterTrade can then be used to build the UniswapTrade entity in this package
var RouterTradeAdapter = /*#__PURE__*/function () {
  function RouterTradeAdapter() {}
  // Generate a RouterTrade using fields from a classic quote response
  RouterTradeAdapter.fromClassicQuote = function fromClassicQuote(quote) {
    var route = quote.route,
      tokenIn = quote.tokenIn,
      tokenOut = quote.tokenOut;
    if (!route) throw new Error('Expected route to be present');
    if (!route.length) throw new Error('Expected there to be at least one route');
    if (route.some(function (r) {
      return !r.length;
    })) throw new Error('Expected all routes to have at least one pool');
    var firstRoute = route[0];
    var tokenInData = firstRoute[0].tokenIn;
    var tokenOutData = firstRoute[firstRoute.length - 1].tokenOut;
    if (!tokenInData || !tokenOutData) throw new Error('Expected both tokenIn and tokenOut to be present');
    if (tokenInData.chainId !== tokenOutData.chainId) throw new Error('Expected tokenIn and tokenOut to be have same chainId');
    var parsedCurrencyIn = RouterTradeAdapter.toCurrency(isNativeCurrency(tokenIn), tokenInData);
    var parsedCurrencyOut = RouterTradeAdapter.toCurrency(isNativeCurrency(tokenOut), tokenOutData);
    var typedRoutes = route.map(function (subRoute) {
      var rawAmountIn = subRoute[0].amountIn;
      var rawAmountOut = subRoute[subRoute.length - 1].amountOut;
      if (!rawAmountIn || !rawAmountOut) {
        throw new Error('Expected both raw amountIn and raw amountOut to be present');
      }
      var inputAmount = sdkCore.CurrencyAmount.fromRawAmount(parsedCurrencyIn, rawAmountIn);
      var outputAmount = sdkCore.CurrencyAmount.fromRawAmount(parsedCurrencyOut, rawAmountOut);
      var isOnlyV2 = RouterTradeAdapter.isVersionedRoute(exports.PoolType.V2Pool, subRoute);
      var isOnlyV3 = RouterTradeAdapter.isVersionedRoute(exports.PoolType.V3Pool, subRoute);
      var isOnlyV4 = RouterTradeAdapter.isVersionedRoute(exports.PoolType.V4Pool, subRoute);
      return {
        routev4: isOnlyV4 ? new v4Sdk.Route(subRoute.map(RouterTradeAdapter.toV4Pool), parsedCurrencyIn, parsedCurrencyOut) : null,
        routev3: isOnlyV3 ? new v3Sdk.Route(subRoute.map(RouterTradeAdapter.toV3Pool), parsedCurrencyIn, parsedCurrencyOut) : null,
        routev2: isOnlyV2 ? new v2Sdk.Route(subRoute.map(RouterTradeAdapter.toPair), parsedCurrencyIn, parsedCurrencyOut) : null,
        mixedRoute: !isOnlyV4 && !isOnlyV3 && !isOnlyV2 ? new routerSdk.MixedRouteSDK(subRoute.map(RouterTradeAdapter.toPoolOrPair), parsedCurrencyIn, parsedCurrencyOut) : null,
        inputAmount: inputAmount,
        outputAmount: outputAmount
      };
    });
    return new routerSdk.Trade({
      v2Routes: typedRoutes.filter(function (route) {
        return route.routev2;
      }).map(function (route) {
        return {
          routev2: route.routev2,
          inputAmount: route.inputAmount,
          outputAmount: route.outputAmount
        };
      }),
      v3Routes: typedRoutes.filter(function (route) {
        return route.routev3;
      }).map(function (route) {
        return {
          routev3: route.routev3,
          inputAmount: route.inputAmount,
          outputAmount: route.outputAmount
        };
      }),
      v4Routes: typedRoutes.filter(function (route) {
        return route.routev4;
      }).map(function (route) {
        return {
          routev4: route.routev4,
          inputAmount: route.inputAmount,
          outputAmount: route.outputAmount
        };
      }),
      mixedRoutes: typedRoutes.filter(function (route) {
        return route.mixedRoute;
      }).map(function (route) {
        return {
          mixedRoute: route.mixedRoute,
          inputAmount: route.inputAmount,
          outputAmount: route.outputAmount
        };
      }),
      tradeType: quote.tradeType
    });
  };
  RouterTradeAdapter.toCurrency = function toCurrency(isNative, token) {
    if (isNative) {
      return sdkCore.Ether.onChain(token.chainId);
    }
    return this.toToken(token);
  };
  RouterTradeAdapter.toToken = function toToken(token) {
    var chainId = token.chainId,
      address = token.address,
      decimals = token.decimals,
      symbol = token.symbol,
      buyFeeBps = token.buyFeeBps,
      sellFeeBps = token.sellFeeBps;
    return new sdkCore.Token(chainId, address, parseInt(decimals.toString()), symbol, /* name */undefined, false, buyFeeBps ? ethers.BigNumber.from(buyFeeBps) : undefined, sellFeeBps ? ethers.BigNumber.from(sellFeeBps) : undefined);
  };
  RouterTradeAdapter.toV3Pool = function toV3Pool(_ref) {
    var fee = _ref.fee,
      sqrtRatioX96 = _ref.sqrtRatioX96,
      liquidity = _ref.liquidity,
      tickCurrent = _ref.tickCurrent,
      tokenIn = _ref.tokenIn,
      tokenOut = _ref.tokenOut;
    return new v3Sdk.Pool(RouterTradeAdapter.toToken(tokenIn), RouterTradeAdapter.toToken(tokenOut), parseInt(fee), sqrtRatioX96, liquidity, parseInt(tickCurrent));
  };
  RouterTradeAdapter.toV4Pool = function toV4Pool(pool) {
    var parsedCurrencyIn = RouterTradeAdapter.toCurrency(isNativeCurrency(pool.tokenIn.address), pool.tokenIn);
    var parsedCurrencyOut = RouterTradeAdapter.toCurrency(isNativeCurrency(pool.tokenOut.address), pool.tokenOut);
    return new v4Sdk.Pool(parsedCurrencyIn, parsedCurrencyOut, parseInt(pool.fee), parseInt(pool.tickSpacing), pool.hooks, pool.sqrtRatioX96, pool.liquidity, parseInt(pool.tickCurrent));
  };
  RouterTradeAdapter.isVersionedRoute = function isVersionedRoute(type, route) {
    return route.every(function (pool) {
      return pool.type === type;
    });
  };
  return RouterTradeAdapter;
}();
RouterTradeAdapter.toPoolOrPair = function (pool) {
  switch (pool.type) {
    case exports.PoolType.V4Pool:
      return RouterTradeAdapter.toV4Pool(pool);
    case exports.PoolType.V3Pool:
      return RouterTradeAdapter.toV3Pool(pool);
    case exports.PoolType.V2Pool:
      return RouterTradeAdapter.toPair(pool);
    default:
      throw new Error('Invalid pool type');
  }
};
RouterTradeAdapter.toPair = function (_ref2) {
  var reserve0 = _ref2.reserve0,
    reserve1 = _ref2.reserve1;
  return new v2Sdk.Pair(sdkCore.CurrencyAmount.fromRawAmount(RouterTradeAdapter.toToken(reserve0.token), reserve0.quotient), sdkCore.CurrencyAmount.fromRawAmount(RouterTradeAdapter.toToken(reserve1.token), reserve1.quotient));
};

// Parses UniversalRouter V2 commands
var CommandParser = /*#__PURE__*/function () {
  function CommandParser() {}
  CommandParser.parseCalldata = function parseCalldata(calldata) {
    var genericParser = new GenericCommandParser(COMMAND_DEFINITION);
    var txDescription = CommandParser.INTERFACE.parseTransaction({
      data: calldata
    });
    var _txDescription$args = txDescription.args,
      commands = _txDescription$args.commands,
      inputs = _txDescription$args.inputs;
    return genericParser.parse(commands, inputs);
  };
  return CommandParser;
}();
CommandParser.INTERFACE = /*#__PURE__*/new abi.Interface(UniversalRouter.abi);
// Parses commands based on given command definition
var GenericCommandParser = /*#__PURE__*/function () {
  function GenericCommandParser(commandDefinition) {
    this.commandDefinition = commandDefinition;
  }
  var _proto = GenericCommandParser.prototype;
  _proto.parse = function parse(commands, inputs) {
    var _this = this;
    var commandTypes = GenericCommandParser.getCommands(commands);
    return {
      commands: commandTypes.map(function (commandType, i) {
        var commandDef = _this.commandDefinition[commandType];
        if (commandDef.parser === exports.Parser.V4Actions) {
          var _V4BaseActionsParser$ = v4Sdk.V4BaseActionsParser.parseCalldata(inputs[i]),
            actions = _V4BaseActionsParser$.actions;
          return {
            commandName: exports.CommandType[commandType],
            commandType: commandType,
            params: v4RouterCallToParams(actions)
          };
        } else if (commandDef.parser === exports.Parser.Abi) {
          var abiDef = commandDef.params;
          var rawParams = ethers.ethers.utils.defaultAbiCoder.decode(abiDef.map(function (command) {
            return command.type;
          }), inputs[i]);
          var params = rawParams.map(function (param, j) {
            switch (abiDef[j].subparser) {
              case exports.Subparser.V3PathExactIn:
                return {
                  name: abiDef[j].name,
                  value: parseV3PathExactIn(param)
                };
              case exports.Subparser.V3PathExactOut:
                return {
                  name: abiDef[j].name,
                  value: parseV3PathExactOut(param)
                };
              default:
                return {
                  name: abiDef[j].name,
                  value: param
                };
            }
          });
          return {
            commandName: exports.CommandType[commandType],
            commandType: commandType,
            params: params
          };
        } else if (commandDef.parser === exports.Parser.V3Actions) {
          // TODO: implement better parsing here
          return {
            commandName: exports.CommandType[commandType],
            commandType: commandType,
            params: inputs.map(function (input) {
              return {
                name: 'command',
                value: input
              };
            })
          };
        } else {
          throw new Error("Unsupported parser: " + commandDef);
        }
      })
    };
  }
  // parse command types from bytes string
  ;
  GenericCommandParser.getCommands = function getCommands(commands) {
    var commandTypes = [];
    for (var i = 2; i < commands.length; i += 2) {
      var _byte = commands.substring(i, i + 2);
      commandTypes.push(parseInt(_byte, 16));
    }
    return commandTypes;
  };
  return GenericCommandParser;
}();
function parseV3PathExactIn(path) {
  var strippedPath = path.replace('0x', '');
  var tokenIn = ethers.ethers.utils.getAddress(strippedPath.substring(0, 40));
  var loc = 40;
  var res = [];
  while (loc < strippedPath.length) {
    var feeAndTokenOut = strippedPath.substring(loc, loc + 46);
    var fee = parseInt(feeAndTokenOut.substring(0, 6), 16);
    var tokenOut = ethers.ethers.utils.getAddress(feeAndTokenOut.substring(6, 46));
    res.push({
      tokenIn: tokenIn,
      tokenOut: tokenOut,
      fee: fee
    });
    tokenIn = tokenOut;
    loc += 46;
  }
  return res;
}
function parseV3PathExactOut(path) {
  var strippedPath = path.replace('0x', '');
  var tokenIn = ethers.ethers.utils.getAddress(strippedPath.substring(strippedPath.length - 40));
  var loc = strippedPath.length - 86; // 86 = (20 addr + 3 fee + 20 addr) * 2 (for hex characters)
  var res = [];
  while (loc >= 0) {
    var feeAndTokenOut = strippedPath.substring(loc, loc + 46);
    var tokenOut = ethers.ethers.utils.getAddress(feeAndTokenOut.substring(0, 40));
    var fee = parseInt(feeAndTokenOut.substring(40, 46), 16);
    res.push({
      tokenIn: tokenIn,
      tokenOut: tokenOut,
      fee: fee
    });
    tokenIn = tokenOut;
    loc -= 46;
  }
  return res;
}
function v4RouterCallToParams(actions) {
  return actions.map(function (action) {
    return {
      name: action.actionName,
      value: action.params.map(function (param) {
        return {
          name: param.name,
          value: param.value
        };
      })
    };
  });
}

exports.COMMAND_DEFINITION = COMMAND_DEFINITION;
exports.CommandParser = CommandParser;
exports.GenericCommandParser = GenericCommandParser;
exports.ROUTER_AS_RECIPIENT = ROUTER_AS_RECIPIENT;
exports.RoutePlanner = RoutePlanner;
exports.RouterTradeAdapter = RouterTradeAdapter;
exports.SwapRouter = SwapRouter;
exports.UNIVERSAL_ROUTER_ADDRESS = UNIVERSAL_ROUTER_ADDRESS;
exports.UNIVERSAL_ROUTER_CREATION_BLOCK = UNIVERSAL_ROUTER_CREATION_BLOCK;
exports.UniswapTrade = UniswapTrade;
exports.UnwrapWETH = UnwrapWETH;
exports.WETH_ADDRESS = WETH_ADDRESS;
exports.isNativeCurrency = isNativeCurrency;
//# sourceMappingURL=universal-router-sdk.cjs.development.js.map
